<div class="wrapper">
<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include"template/include/aspetto/{$aspettoSito["cartellaMenu"]}/menuPrincipale.php";
?>
   <div id="content" class="d-flex flex-column">
        <button id="sidebarCollapse" class="hamburger" type="button" aria-label="Menu" aria-controls="navbarCollapse">
            <span class="hamburger-box">
                <span class="hamburger-inner"></span>
            </span>
        </button>
        <div class="page-wrapper">
            <header>
                <?php 
                    if($impostazioni["attivaBarraSuperiore"]=="si") {
                        include "template/include/aspetto/{$aspettoSito["cartellaMenu"]}/barraSuperiore.php";
                    }
                ?>
            </header>
            
            <!-- Inizio contenuto pagina -->
            <main role="main">
                <section class="ecommerce siOverflow">

                    <div class="container">
                        <div class="row">
                            <?php
                                include "template/include/ecommerce/breadcrumb.php";
                            ?>

                            <!-- Articolo -->
                            <div class="col-lg-6 mb-5">
                                <?php
                                    if($prodotto["prezzoOfferta"]>0) {
                                        echo"<span class=\"in-offerta\"></span>";
                                    }
                                ?>
                                <div class="owl-carousel owl-theme prodotto-slider">
                                    <?php 
                                        $queryNomiGruppi = "SELECT * FROM geec_immagini WHERE tipoImmagine LIKE 'immagineProdotto' AND idContenuto={$prodotto["id"]} ORDER BY posizione ASC";
                                        $risImmagini = $geecomDb->eseguiQueryLettura($queryNomiGruppi);
                                        if($risImmagini->num_rows>0) {
                                            while($immagine = $risImmagini->fetch_assoc()) {
                                                echo"<a href=\"{$immagine["percorso"]}\"
                                                    data-toggle=\"lightbox\" 
                                                    data-gallery=\"nome-della-galleria\" 
                                                    data-title=\"{$prodotto["nome"]}\" 
                                                    data-footer=\"{$immagine["descrizione"]}\">
                                                    <div class=\"aspect-ratio-4-3\">
                                                        <img src=\"{$immagine["percorso"]}\" class=\"img-fluid\"> <!--/thumbnail-->
                                                    </div>
                                                </a>";
                                            }
                                        }
                                        else if($prodotto["immagine"]!="") {
                                            echo"<a href=\"{$prodotto["immagine"]}\"
                                                    data-toggle=\"lightbox\" 
                                                    data-gallery=\"nome-della-galleria\" 
                                                    data-title=\"{$prodotto["nome"]}\" 
                                                    data-footer=\"\">
                                                    <div class=\"aspect-ratio-4-3\">
                                                        <img src=\"{$prodotto["immagine"]}\" class=\"img-fluid\"> <!--/thumbnail-->
                                                    </div>
                                                </a>";
                                        }
                                        else {
                                            echo"<a href=\"immagini/altro/segnaposto.png\"
                                                    data-toggle=\"lightbox\" 
                                                    data-gallery=\"nome-della-galleria\" 
                                                    data-title=\"{$prodotto["nome"]}\" 
                                                    data-footer=\"\">
                                                    <div class=\"aspect-ratio-4-3\">
                                                        <img src=\"immagini/altro/segnaposto.png\" class=\"img-fluid\"> <!--/thumbnail-->
                                                    </div>
                                                 </a>";
                                        }
                                    ?>
                                </div>
                            </div>
                            <div class="col-lg-6 mb-5">            
                                    <div class="row">
                                        <?php
                                            // includo la seconda colonna se è posizionata a destra
                                            if($impostazioniEcommerce["posizioneBarraLaterale"]=="sinistra") {
                                                $classeColonnaPrincipale = "order-md-1";
                                            }
                                            else {
                                                $classeColonnaPrincipale = "order-md-0";
                                            }
                                        ?>
                                        <div class="col <?php echo $classeColonnaPrincipale; ?>">
                                            <h1 class="mb-3"><?php echo $prodotto["nome"]; ?></h1>
                                            <?php 
                                                if($prodotto["ean"]!="" && $impostazioniEcommerce["mostraEanPaginaProdotto"]=="si") {
                                                    ?>                                        
                                                    <p><b>EAN:</b><?= $prodotto["ean"] ?></p>
                                                    <?php
                                                }
                                                
                                                if($prodotto["categoria"]!=0) {
                                                    $categoria = $geecomDb->leggiSingolaRiga("geec_categorie",$prodotto["categoria"]);
                                                    $linkCategoria = GeneratoreUrl::creaUrlCategoria($categoria,$impostazioni["ottimizzazioneUrl"],$impostazioni["urlSito"]);
                                                    echo"<a href=\"$linkCategoria\" class=\"badge badge-primary rounded-0 py-2 px-3 mb-2\">{$categoria["nome"]}</a>";
                                                }
                                                
                                                echo $prodotto["descrizione"];
                                            ?>
                                                <div class="row mb-3">
                                                    <div class="col">
                                                        <?php
		                                            $prezzoBase    = ($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA inclusa") ? $prodotto["prezzo"] + ($prodotto["prezzo"] * $prodotto["iva"] / 100) : $prodotto["prezzo"];
		                                            $prezzoOfferta = ($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA inclusa") ? $prodotto["prezzoOfferta"] + ($prodotto["prezzoOfferta"] * $prodotto["iva"] / 100) : $prodotto["prezzoOfferta"];
		                                            $asterisco     = "";
		                                                        
		                                            // imposto il suffisso IVA
		                                            if($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA esclusa") {
		                                                $suffissoIva = $gestoreTraduzioni->traduci("+ IVA",$prodotto["lingua"]);
		                                            }
		                                            else if($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA inclusa") {
		                                                $suffissoIva = $gestoreTraduzioni->traduci("IVA inclusa",$prodotto["lingua"]);
		                                            }
		                                            else {
		                                                $suffissoIva = "";
		                                            }
		                                            
                                                            if($datiGruppo != null) {
                                                                $prezzoBase    = round($prezzoBase - ($prezzoBase * $datiGruppo["percentualeSconto"] / 100),2);
                                                                $prezzoOfferta = ($prezzoOfferta!=0) ? round($prezzoOfferta - ($prezzoOfferta * $datiGruppo["percentualeSconto"] / 100),2) : 0;
                                                                $asterisco = "*";
                                                            }

                                                            // inizializza la variabile prezzoProdotto (serve in vari punti sotto)
                                                            if($prezzoOfferta>0) {
                                                                $prezzoPodotto = $prezzoOfferta;
                                                            }
                                                            else {
                                                                $prezzoPodotto = $prezzoBase;
                                                            }
                                                        ?>
                                                        <input id="inputPrezzoProdotto" class="d-none" value="<?php echo $prezzoPodotto; ?>">
                                                        <?php 
		                                            if($prodotto["usaVariazioni"]=="si") {
		                                                $queryVariazionePiuEconomica  = "SELECT * FROM geecEc_variazioniProdotto WHERE idProdotto ={$prodotto["id"]} ORDER BY costo ASC LIMIT 1";
		                                                $risVariazionePiuEconomica     = $geecomDb->eseguiQueryLettura($queryVariazionePiuEconomica);
		                                                $datiVariazionePiuEconomica    = $risVariazionePiuEconomica->fetch_assoc();
		                                                $prezzoVariazionePiuEconomica  = ($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA inclusa") ? $datiVariazionePiuEconomica["costo"] + ($datiVariazionePiuEconomica["costo"] * $prodotto["iva"] / 100) : $datiVariazionePiuEconomica["costo"];
		                                                echo"<h4 id=\"labelPrezzoProdotto\" class=\"text-primary mb-0 mt-3\"><strong>A partire da $prezzoVariazionePiuEconomica € </strong> <small>$suffissoIva</small></h4>";
		                                            }
		                                            else {
		                                                if($prodotto["prezzoOfferta"]>0) {
		                                                      echo"<h4 id=\"labelPrezzoProdotto\" class=\"text-primary mb-0 mt-3\"><strong> $prezzoPodotto € </strong> <small>$suffissoIva</small></h4>";
		                                                    echo"<h6 class=\"text-muted\"><del>{$prodotto["prezzo"]} € <small>$suffissoIva</small></del></h6>";
		                                                }
		                                                else {
		                                                      echo"<h4 id=\"labelPrezzoProdotto\" class=\"text-primary mb-0 mt-3\"><strong> $prezzoPodotto € </strong> <small>$suffissoIva</small></h4>";
		                                                }
		                                            }
                                                        ?>
                                                    </div>
                                                </div>
                                                <?php 
                                                    // se mostraPezziRimanenti == si, non è un prodotto inesauribile e non è un prodotto con variazioni mostra la quantità in magazzino
                                                    if($prodotto["prodottoInesauribile"]=="no" && $prodotto["usaVariazioni"]!="si") {
                                                        if($prodotto["disponibilita"]>0) {
		                                         	if($impostazioniEcommerce["mostraPezziRimanenti"]=="si") {
						                ?>
								    <div class="clearfix mb-2 text-success">
						                        <small><strong><?php echo $prodotto["disponibilita"]; ?>  <?php echo $gestoreTraduzioni->traduci("pz in magazzino",$lingua) ?></strong></small>
						                    </div>
						                 <?php
		                                         	}
                                                        }
                                                        else {
                                                ?>
                                                    <div class="clearfix mb-2 text-danger">
                                                        <small><strong><?php echo $gestoreTraduzioni->traduci("Questo articolo non è al momento disponibile",$lingua) ?></strong></small>
                                                    </div>
                                                <?php
                                                        }
                                                    }
                                                ?>
                                               <form>
                                                    <?php 
                                                        if($impostazioniEcommerce["mostraSelettoreQuantita"]=="si") {
                                                    ?>
                                                            <div class="d-flex justify-content-between mb-3">
                                                                <label class="my-1 mr-2" for="quantita"><strong><?php echo $gestoreTraduzioni->traduci("Quantità",$lingua) ?></strong></label>
                                                                <input type="number" class="form-control" name="quantita" id="quantita" min="<?php echo $prodotto["minimoAcquisto"] ?>" value="<?php echo $prodotto["minimoAcquisto"] ?>">
                                                            </div>
                                                    <?php 
                                                        }
                                                        else {
                                                            echo"<input type=\"number\" class=\"d-none\" name=\"quantita\" id=\"quantita\" value=\"1\">";
                                                        }   

                                                        if($prodotto["usaVariazioni"]=="si") {
                                                                $attributo = array("nome"=>""); // il campo attributo in questo caso non viene usato

                                                                $queryVariazioni = "SELECT * FROM geecEc_variazioniProdotto WHERE idProdotto ={$prodotto["id"]}";
                                                                $risVariazioni = $geecomDb->eseguiQueryLettura($queryVariazioni);
                                                            ?>
                                                                    <label for="quantita">Seleziona versione </label>
                                                                    <div class="form-group">
                                                                        <select class="form-control" id="variazioneProdotto<?= $prodotto["id"] ?>" onchange="aggiornaPrezzoVariante(<?= $prodotto["id"] ?>)">
                                                                            <?php 
											while($variazione = $risVariazioni->fetch_assoc()) {
											    $prezzoVariazione = ($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA inclusa") ? $variazione["costo"] + ($variazione["costo"] * $prodotto["iva"] / 100) : $variazione["costo"];
											    echo"<option value=\"{$variazione["id"]}\" >{$variazione["nome"]} ({$prezzoVariazione} €)</option>";
											}
                                                                            ?>
                                                                        </select>
                                                                    </div>
                                                            <?php 
                                                        }
                                                        else {
                                                            $numeroAttributi = 0;
                                                            $elencoAttributi = "";
                                                            $attributoTmp    = [];

                                                            $queryAttributi  = "SELECT * FROM geecEc_attributiProdotto WHERE idProdotto ={$prodotto["id"]}";
                                                            $risAttributi    = $geecomDb->eseguiQueryLettura($queryAttributi);
                                                            while($attributo = $risAttributi->fetch_assoc()) {
                                                                $attributoTmp   = $attributo;
                                                                $arrayAttributi = explode(",",$attributo["valori"]);
                                                                $arrayPrezzi    = explode(",",$attributo["costi"]);
                                                        ?>
                                                                <label for="quantita"><?= $attributo["nome"]; ?></label>
                                                                <div class="form-group">
                                                                    <select class=form-control id="<?= $attributo["nome"]; ?>" name="<?= $attributo["nome"]; ?>">
                                                                        <option value="">Seleziona</option>
                                                                        <?php 
                                                                            foreach($arrayAttributi as $valoreAttributo) {
                                                                                echo"<option value=\"$valoreAttributo\">$valoreAttributo</option>";
                                                                            }
                                                                        ?>
                                                                     </select>
                                                                </div>
                                                        <?php 
                                                                $numeroAttributi++;

                                                                $elencoAttributi .= $attributoTmp["nome"].",";
                                                            }

                                                            if($numeroAttributi>0) {
                                                                $elencoAttributi = substr($elencoAttributi,0,-1);
                                                            }
                                                        }
                                                    ?>
                                                </form>
                                                <?php
                                                    if($impostazioniEcommerce["messaggioPulsanteCarrelloPaginaProdotti"]!="") {
                                                ?>
                                                <div class="bg-light p-3 border mb-3"><?= $impostazioniEcommerce["messaggioPulsanteCarrelloPaginaProdotti"] ?></div>
                                                <?php 
                                                    }
                                                    
                                                    if($impostazioniEcommerce["bloccaAcquisti"]!="si") {
                                                ?>
                                                    <button class="btn btn-outline-primary btn-block sharp aggiungi" onclick="aggiungiAlCarrelloPaginaProdotto('prodottoEcommerce',<?php echo $prodotto["id"]; ?>,'<?= $elencoAttributi ?>','<?php echo $prodotto["nome"]; ?>','<?php echo $prodotto["immagine"]; ?>',<?php echo(($prodotto["prodottoInesauribile"]=="si") ? "10000" : $prodotto["disponibilita"]); ?>)" ><?php echo $gestoreTraduzioni->traduci("Aggiungi al carrello",$lingua) ?></button>
                                                <?php
                                                    }
                                                    
                                                    if($impostazioniEcommerce["mostraTempoNecessarioConsegna"]=="si") {
                                                        $query = "SELECT * FROM geecEc_metodiSpedizione ORDER BY giorniNecessari DESC LIMIT 1";
                                                        $risSpedizioni = $geecomDb->eseguiQueryLettura($query);

                                                        $spedizione = $risSpedizioni->fetch_assoc();

                                                        if(date("D")=="Sun" && $spedizione["giorniInCuiSiSpedisce"]!="Tutti i giorni") {
                                                          $spedizione["giorniNecessari"] ++;
                                                        }

                                                        if(date("D")=="Sat" && $spedizione["giorniInCuiSiSpedisce"]!="Tutti i giorni") {
                                                          $spedizione["giorniNecessari"] ++;
                                                        }

                                                        $arrayOrarioLimite = explode(":", $spedizione["orarioLimite"]);
                                                        if((date("H") == $arrayOrarioLimite[0] &&  date("i") >= $arrayOrarioLimite[1]) || date("H") > $arrayOrarioLimite[0]) {
                                                            $spedizione["giorniNecessari"] ++;
                                                        }

                                                        if($spedizione["giorniNecessari"]==1) {
                                                          $dataConsegna = date("d/m/Y",strtotime("+1 day"));
                                                        }
                                                        else {
                                                          $dataConsegna = date("d/m/Y",strtotime("+{$spedizione["giorniNecessari"]} days"));
                                                        }
                                                ?>
                                                        <p><b><?= str_replace("__data__",$dataConsegna,$impostazioniEcommerce["fraseTempoNecessarioConsegna"]) ?></b></p>
                                                <?php
                                                    }
                                                ?>
                                        </div>
                                        <div class="col-auto social-sharing sticky-top align-self-start">
                                            <?php 
                                                include "template/include/contenuti/condivisioniSocial.php";
                                            ?>
                                        </div>
                                     </div>
                                </div>
                            </div>
                        
                            <div class="mt-4">
                                <?php 
                                    include "template/include/ecommerce/raccomandazioniProdotti.php";
                                ?>
                            </div>
                    </div><!--/#colonna principale-->
                </section>

                <div id="contenitoreComponenti">
                <?php 
                    UtilTemplate::stampaComponenti($geecomDb, $gestoreJavascript, $impostazioni, $prodotto["id"],$gestoreTraduzioni,$lingua,"prodotto");
                ?>
                </div>
            </main>
        </div>
    <?php 
	include "template/include/aspetto/{$aspettoSito["cartellaFooter"]}/footer.php";
        echo $inclusioni["footer"];
    ?>
    </div>
    
    <div class="overlay"></div>
    <?php
        $gestoreJavascript->aggiungiJavascript("<script src=\"https://cdnjs.cloudflare.com/ajax/libs/malihu-custom-scrollbar-plugin/3.1.5/jquery.mCustomScrollbar.concat.min.js\"></script>
        <script type=\"text/javascript\">
        $(document).ready(function () {
            $(\"#sidebar\").mCustomScrollbar({
                theme: \"minimal\"
            });

            $('#dismiss, .overlay').on('click', function () {
                $('#sidebar').removeClass('active');
                $('.overlay').removeClass('active');
            });

            $('#sidebarCollapse').on('click', function () {
                $('#sidebar').addClass('active');
                $('.overlay').addClass('active');
                $('.collapse.in').toggleClass('in');
                $('a[aria-expanded=true]').attr('aria-expanded', 'false');
            });
        });
    </script>");
